//-----------------------------------------------------------------------------
//
//  $Logfile:: /Quake 2 Engine/Sin/code/game/ctf_player.h                     $
// $Revision:: 3                                                              $
//   $Author:: Jimdose                                                        $
//     $Date:: 10/10/98 3:37a                                                 $
//
// Copyright (C) 1998 by Ritual Entertainment, Inc.
// All rights reserved.
//
// This source may not be distributed and/or modified without
// expressly written permission by Ritual Entertainment, Inc.
//
// $Log:: /Quake 2 Engine/Sin/code/game/ctf_player.h                          $
// 
// 3     10/10/98 3:37a Jimdose
// Began converting to Sin
// 
// 2     10/10/98 3:03a Jimdose
// Created file
// 
// 1     10/10/98 3:02a Jimdose
//
// DESCRIPTION:
// Player code for Threewave Capture the Flag.
//
// The original source for this code was graciously provided by Zoid and
// Id Software.  Many thanks!
//
// Original credits:
//
// Programming             - Dave 'Zoid' Kirsch
// Original CTF Art Design - Brian 'Whaleboy' Cozzens
// 

#ifndef __CTF_PLAYER_H__
#define __CTF_PLAYER_H__

#include "player.h"
#include "ctf.h"

class EXPORT_FROM_DLL CTF_Player : public Player
	{
	private:
      int               team;

	public:

      CLASS_PROTOTYPE( CTF_Player );

								CTF_Player();
		virtual				~CTF_Player();
		virtual void		Init( void );

      const char        *TeamName( void );
      const char        *OtherTeamName( void );
      int               Team( void );
      int               OtherTeam( void );

      virtual void		Respawn( Event *ev );
		virtual void		Killed( Event *ev );
		virtual void		GotKill( Event *ev );
		void					ClientThink( Event *ev );
		virtual void		EndFrame( Event *ev );

		virtual void		UpdateStats( void );

      virtual void		Prethink( void );
		virtual void		Postthink( void );
		
	   virtual void      Archive( Archiver &arc );
      virtual void      Unarchive( Archiver &arc );
   };

inline EXPORT_FROM_DLL void CTF_Player::Archive
	(
	Archiver &arc
	)

   {
   Player::Archive( arc );
   }

inline EXPORT_FROM_DLL void CTF_Player::Unarchive
	(
	Archiver &arc
	)

   {
   Player::Unarchive( arc );
   }

#endif /* ctf_player.h */
